/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid.ranged;

import dev.xkmc.mob_weapon_api.api.projectile.ProjectileWeaponUser;
import dev.xkmc.mob_weapon_api.api.simple.IInstantWeaponBehavior;
import dev.xkmc.mob_weapon_api.registry.WeaponRegistry;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemRangedAttackGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.ranged.GolemUser;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GolemSimpleRangedAttackGoal
extends GolemRangedAttackGoal {
    private int attackTime = -1;

    public GolemSimpleRangedAttackGoal(HumanoidGolemEntity mob, GolemMeleeGoal melee, double speed) {
        super(mob, melee, speed, 0.0);
    }

    @Override
    public boolean mayActivate(HumanoidGolemEntity golem, ItemStack stack) {
        Optional weapon = WeaponRegistry.INSTANT.get((LivingEntity)this.mob, stack);
        return weapon.isPresent() && ((IInstantWeaponBehavior)weapon.get()).isValid((ProjectileWeaponUser)new GolemUser(golem, null), stack);
    }

    @Override
    public void m_8041_() {
        this.attackTime = -1;
    }

    @Override
    public double radius(ItemStack stack) {
        Optional weapon = WeaponRegistry.INSTANT.get((LivingEntity)this.mob, stack);
        return weapon.map(b -> b.range((ProjectileWeaponUser)new GolemUser(this.mob, null), stack)).orElse(0.0);
    }

    public void m_8037_() {
        this.doMelee();
        this.strafing();
        if (this.attackTime > 0) {
            --this.attackTime;
            return;
        }
        ItemStack stack = this.mob.m_21120_(this.mob.getWeaponHand());
        Optional weapon = WeaponRegistry.INSTANT.get((LivingEntity)this.mob, stack);
        if (weapon.isEmpty()) {
            return;
        }
        LivingEntity target = this.mob.m_5448_();
        GolemUser user = new GolemUser(this.mob, target);
        if (this.seeTime > 0 && target != null && (double)this.mob.m_20270_((Entity)target) < ((IInstantWeaponBehavior)weapon.get()).range((ProjectileWeaponUser)user, stack)) {
            this.attackTime = ((IInstantWeaponBehavior)weapon.get()).trigger((ProjectileWeaponUser)user, stack, target);
        }
    }

    @Override
    public void performRangedAttack(HumanoidGolemEntity golem, LivingEntity target, float power, ItemStack stack, InteractionHand hand) {
    }
}

